#ifndef MEMMAP_H
#define MEMMAP_H

#define CFG_SIZE   (0x80)
#define REG_SIZE   (0x00000200)
#define MEM_SIZE   (0x0000f000)
/*
#define REG_SIZE   (0x00000200)
#define MEM_SIZE   (0x0000f000)

#define REG_SIZE   (0x00010000)
#define MEM_SIZE   (0x00010000)
*/

#ifdef __alpha
#ifdef __osf__
#include <c_asm.h>
#endif /* __osf__ */
#define MB asm("mb")
#else /* __alpha */
#define MB /* do nothing */
#endif

#define TBmemWriteInt(addr, value){*(((u_int *)mp)+(addr)) = (value);MB;}

unsigned int * TBopen(int devid);
void TBterm(int devid);
unsigned int TBconfigRead(int devid, unsigned int addr);
void TBconfigWrite(int devid, unsigned int addr, unsigned int value);
unsigned int TBmemRead(int devid, unsigned int addr);
void TBmemWrite(int devid, unsigned int addr, unsigned int value);
unsigned int TBregRead(int devid, unsigned int addr);
void TBregWrite(int devid, unsigned int addr, unsigned int value);
#ifdef __linux__
void TBgetDmaInfo(int devid, unsigned long *pa, unsigned int **va);
#elif defined(__DECC)
unsigned long TBdmaMapLoad(int devid, unsigned int * buf, int size);
#else
#error "unsupported environment"
#endif

#endif /* MEMMAP_H */
