/*
 * FADDTEST.C
 *
 * test vector generator for fadd
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Dec 29 1997
 *
 * OUTPUT FORMAT: HEX format
 * in1 accin offset clear accout errorcode
 * hex format for in1 : packed (in the order of exponent, sign, zero and mantissa)
 *
 */
#include "grape6sim.h"
void print_fadd_test(ULONG exp1,
		    ULONG sign1,
		    ULONG zero1,
		    ULONG mantissa1,
		    LONG offset,
		    ULONG clear,
		    LONG * accumulator);
void print_fadd_test(ULONG exp1,
		    ULONG sign1,
		    ULONG zero1,
		    ULONG mantissa1,
		    LONG offset,
		    ULONG clear,
		    LONG * accumulator)
{
  ULONG in1, in2, sum, nbits, nbits_acc, errorcode;
  LONG acc_old;
  double f1, f2, fsum;
  nbits = BITS;
  nbits_acc = ABITS;
  in1 = compose_float(nbits, exp1, sign1,  zero1,  mantissa1);
  acc_old = *accumulator;
  f1 = convert_grape_float_to_double(in1, nbits);
  errorcode = fadd(in1, accumulator, nbits, offset, nbits_acc, clear);
  printf("%lx %lx %lx %lx %lx %lx\n", in1, acc_old, offset & 0xfff, clear, *accumulator,errorcode);
}


main()
{
  ULONG  in1,  inb1, inb2;
  ULONG exp1, sign1, zero1, mantissa1;
  LONG acc, offset;
  ULONG clear;
  int  i;
  inb1 =  BITS;
  inb2 = ABITS;

  /* shifting test for simple mantissa */
  for(i= 440;i <570; i ++){
    exp1 = INTERACTION_POSITION_EXP_OFFSET;
    offset = i;
    offset = - offset;
    sign1 =  0;
    zero1 =  0;
    mantissa1 =  (ULONG_ONE) << (BITS-1);
    clear  = 0;
    acc = 0x10000000;
    print_fadd_test(exp1, sign1, zero1, mantissa1, offset, clear, &acc);
  }
  /* shifting test for a bit complex simple mantissa */
  for(i= 512-ABITS-5;i <512; i ++){
    exp1 = INTERACTION_POSITION_EXP_OFFSET;
    offset = i;
    offset = - offset;
    sign1 =  0;
    zero1 =  0;
    mantissa1 =  0x5555555555;
    clear  = 0;
    acc = 0x10000000;
    print_fadd_test(exp1, sign1, zero1, mantissa1, offset, clear, &acc);
  }
  /* shifting test for a simple mantissa, subtraction */
  for(i= 512-ABITS-5;i <520; i ++){
    exp1 = INTERACTION_POSITION_EXP_OFFSET;
    offset = i;
    offset = - offset;
    sign1 =  1;
    zero1 =  0;
    mantissa1 =  (ULONG_ONE) << (BITS-1);
    clear  = 0;
    acc = (ULONG_ONE)<<(ABITS-2);
    print_fadd_test(exp1, sign1, zero1, mantissa1, offset, clear, &acc);
  }
  /* shifting test for a simple mantissa, addition */
  for(i= 512-ABITS-5;i <520; i ++){
    exp1 = INTERACTION_POSITION_EXP_OFFSET;
    offset = i;
    offset = - offset;
    sign1 =  0;
    zero1 =  0;
    mantissa1 =  (ULONG_ONE) << (BITS-1);
    clear  = 0;
    acc = -1;
    print_fadd_test(exp1, sign1, zero1, mantissa1, offset, clear, &acc);
  }
  /* shifting test for a complex addition, overflow test  */
  for(i= 512-ABITS-5;i <512-ABITS+20; i ++){
    exp1 = INTERACTION_POSITION_EXP_OFFSET;
    offset = i;
    offset = - offset;
    sign1 =  0;
    zero1 =  0;
    clear  = 0;
    acc = ((LONG)0x7fffff)<<(ABITS-24);
    mantissa1 =  (ULONG_ONE << BITS)-1;
    print_fadd_test(exp1, sign1, zero1, mantissa1, offset, clear, &acc);
    acc = ((LONG)0x7fffff)<<(ABITS-24);
    mantissa1 =  (ULONG_ONE << (BITS-1));
    print_fadd_test(exp1, sign1, zero1, mantissa1, offset, clear, &acc);
  }
  exit(1);
  for(i= 0;i <ABITS; i ++){
    exp1 = INTERACTION_POSITION_EXP_OFFSET;
    offset = exp1 - 32;
    offset = - offset;
    sign1 =  0;
    zero1 =  0;
    clear  = 0;
    acc = (LONG_ONE) <<i;
    mantissa1 =  (ULONG_ONE << BITS)-1;
    print_fadd_test(exp1, sign1, zero1, mantissa1, offset, clear, &acc);
  }
}

